/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.union;

import java.util.TreeSet;
import org.locationtech.jts.algorithm.PointLocator;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateArrays;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Puntal;
import org.locationtech.jts.geom.util.GeometryCombiner;

public class PointGeometryUnion {
    private Geometry pointGeom;
    private Geometry otherGeom;
    private GeometryFactory geomFact;

    public static Geometry union(Puntal pointGeom, Geometry otherGeom) {
        PointGeometryUnion unioner = new PointGeometryUnion(pointGeom, otherGeom);
        return unioner.union();
    }

    public PointGeometryUnion(Puntal pointGeom, Geometry otherGeom) {
        this.pointGeom = (Geometry)((Object)pointGeom);
        this.otherGeom = otherGeom;
        this.geomFact = otherGeom.getFactory();
    }

    public Geometry union() {
        PointLocator locater = new PointLocator();
        TreeSet<Coordinate> exteriorCoords = new TreeSet<Coordinate>();
        int i = 0;
        while (i < this.pointGeom.getNumGeometries()) {
            Point point = (Point)this.pointGeom.getGeometryN(i);
            Coordinate coord = point.getCoordinate();
            int loc = locater.locate(coord, this.otherGeom);
            if (loc == 2) {
                exteriorCoords.add(coord);
            }
            ++i;
        }
        if (exteriorCoords.size() == 0) {
            return this.otherGeom;
        }
        Geometry ptComp = null;
        Coordinate[] coords = CoordinateArrays.toCoordinateArray(exteriorCoords);
        ptComp = coords.length == 1 ? this.geomFact.createPoint(coords[0]) : this.geomFact.createMultiPointFromCoords(coords);
        return GeometryCombiner.combine(ptComp, this.otherGeom);
    }
}

