/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.union;

import java.util.ArrayList;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.util.GeometryCombiner;

public class UnionInteracting {
    private GeometryFactory geomFactory;
    private Geometry g0;
    private Geometry g1;
    private boolean[] interacts0;
    private boolean[] interacts1;

    public static Geometry union(Geometry g0, Geometry g1) {
        UnionInteracting uue = new UnionInteracting(g0, g1);
        return uue.union();
    }

    public UnionInteracting(Geometry g0, Geometry g1) {
        this.g0 = g0;
        this.g1 = g1;
        this.geomFactory = g0.getFactory();
        this.interacts0 = new boolean[g0.getNumGeometries()];
        this.interacts1 = new boolean[g1.getNumGeometries()];
    }

    public Geometry union() {
        this.computeInteracting();
        Geometry int0 = this.extractElements(this.g0, this.interacts0, true);
        Geometry int1 = this.extractElements(this.g1, this.interacts1, true);
        if (int0.isEmpty() || int1.isEmpty()) {
            System.out.println("found empty!");
        }
        Geometry union = int0.union(int1);
        Geometry disjoint0 = this.extractElements(this.g0, this.interacts0, false);
        Geometry disjoint1 = this.extractElements(this.g1, this.interacts1, false);
        Geometry overallUnion = GeometryCombiner.combine(union, disjoint0, disjoint1);
        return overallUnion;
    }

    private Geometry bufferUnion(Geometry g0, Geometry g1) {
        GeometryFactory factory = g0.getFactory();
        GeometryCollection gColl = factory.createGeometryCollection(new Geometry[]{g0, g1});
        Geometry unionAll = gColl.buffer(0.0);
        return unionAll;
    }

    private void computeInteracting() {
        int i = 0;
        while (i < this.g0.getNumGeometries()) {
            Geometry elem = this.g0.getGeometryN(i);
            this.interacts0[i] = this.computeInteracting(elem);
            ++i;
        }
    }

    private boolean computeInteracting(Geometry elem0) {
        boolean interactsWithAny = false;
        int i = 0;
        while (i < this.g1.getNumGeometries()) {
            Geometry elem1 = this.g1.getGeometryN(i);
            boolean interacts = elem1.getEnvelopeInternal().intersects(elem0.getEnvelopeInternal());
            if (interacts) {
                this.interacts1[i] = true;
            }
            if (interacts) {
                interactsWithAny = true;
            }
            ++i;
        }
        return interactsWithAny;
    }

    private Geometry extractElements(Geometry geom, boolean[] interacts, boolean isInteracting) {
        ArrayList<Geometry> extractedGeoms = new ArrayList<Geometry>();
        int i = 0;
        while (i < geom.getNumGeometries()) {
            Geometry elem = geom.getGeometryN(i);
            if (interacts[i] == isInteracting) {
                extractedGeoms.add(elem);
            }
            ++i;
        }
        return this.geomFactory.buildGeometry(extractedGeoms);
    }
}

