/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.valid;

import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;

public class RepeatedPointTester {
    private Coordinate repeatedCoord;

    public Coordinate getCoordinate() {
        return this.repeatedCoord;
    }

    public boolean hasRepeatedPoint(Geometry g) {
        if (g.isEmpty()) {
            return false;
        }
        if (g instanceof Point) {
            return false;
        }
        if (g instanceof MultiPoint) {
            return false;
        }
        if (g instanceof LineString) {
            return this.hasRepeatedPoint(((LineString)g).getCoordinates());
        }
        if (g instanceof Polygon) {
            return this.hasRepeatedPoint((Polygon)g);
        }
        if (g instanceof GeometryCollection) {
            return this.hasRepeatedPoint((GeometryCollection)g);
        }
        throw new UnsupportedOperationException(g.getClass().getName());
    }

    public boolean hasRepeatedPoint(Coordinate[] coord) {
        int i = 1;
        while (i < coord.length) {
            if (coord[i - 1].equals(coord[i])) {
                this.repeatedCoord = coord[i];
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean hasRepeatedPoint(Polygon p) {
        if (this.hasRepeatedPoint(p.getExteriorRing().getCoordinates())) {
            return true;
        }
        int i = 0;
        while (i < p.getNumInteriorRing()) {
            if (this.hasRepeatedPoint(p.getInteriorRingN(i).getCoordinates())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean hasRepeatedPoint(GeometryCollection gc) {
        int i = 0;
        while (i < gc.getNumGeometries()) {
            Geometry g = gc.getGeometryN(i);
            if (this.hasRepeatedPoint(g)) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

