/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.planargraph;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.planargraph.DirectedEdge;
import org.locationtech.jts.planargraph.Edge;

public class DirectedEdgeStar {
    protected List outEdges = new ArrayList();
    private boolean sorted = false;

    public void add(DirectedEdge de) {
        this.outEdges.add(de);
        this.sorted = false;
    }

    public void remove(DirectedEdge de) {
        this.outEdges.remove(de);
    }

    public Iterator iterator() {
        this.sortEdges();
        return this.outEdges.iterator();
    }

    public int getDegree() {
        return this.outEdges.size();
    }

    public Coordinate getCoordinate() {
        Iterator it = this.iterator();
        if (!it.hasNext()) {
            return null;
        }
        DirectedEdge e = (DirectedEdge)it.next();
        return e.getCoordinate();
    }

    public List getEdges() {
        this.sortEdges();
        return this.outEdges;
    }

    private void sortEdges() {
        if (!this.sorted) {
            Collections.sort(this.outEdges);
            this.sorted = true;
        }
    }

    public int getIndex(Edge edge) {
        this.sortEdges();
        int i = 0;
        while (i < this.outEdges.size()) {
            DirectedEdge de = (DirectedEdge)this.outEdges.get(i);
            if (de.getEdge() == edge) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int getIndex(DirectedEdge dirEdge) {
        this.sortEdges();
        int i = 0;
        while (i < this.outEdges.size()) {
            DirectedEdge de = (DirectedEdge)this.outEdges.get(i);
            if (de == dirEdge) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int getIndex(int i) {
        int modi = i % this.outEdges.size();
        if (modi < 0) {
            modi += this.outEdges.size();
        }
        return modi;
    }

    public DirectedEdge getNextEdge(DirectedEdge dirEdge) {
        int i = this.getIndex(dirEdge);
        return (DirectedEdge)this.outEdges.get(this.getIndex(i + 1));
    }

    public DirectedEdge getNextCWEdge(DirectedEdge dirEdge) {
        int i = this.getIndex(dirEdge);
        return (DirectedEdge)this.outEdges.get(this.getIndex(i - 1));
    }
}

