/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.shape.fractal;

import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineSegment;
import org.locationtech.jts.shape.GeometricShapeBuilder;
import org.locationtech.jts.shape.fractal.HilbertCode;

public class HilbertCurveBuilder
extends GeometricShapeBuilder {
    private int order = -1;

    public HilbertCurveBuilder(GeometryFactory geomFactory) {
        super(geomFactory);
        this.extent = null;
    }

    public void setLevel(int level) {
        this.numPts = HilbertCode.size(level);
    }

    @Override
    public Geometry getGeometry() {
        int level = HilbertCode.level(this.numPts);
        int nPts = HilbertCode.size(level);
        double scale = 1.0;
        double baseX = 0.0;
        double baseY = 0.0;
        if (this.extent != null) {
            LineSegment baseLine = this.getSquareBaseLine();
            baseX = baseLine.minX();
            baseY = baseLine.minY();
            double width = baseLine.getLength();
            int maxOrdinate = HilbertCode.maxOrdinate(level);
            scale = width / (double)maxOrdinate;
        }
        Coordinate[] pts = new Coordinate[nPts];
        int i = 0;
        while (i < nPts) {
            Coordinate pt = HilbertCode.decode(level, i);
            double x = HilbertCurveBuilder.transform(pt.getX(), scale, baseX);
            double y = HilbertCurveBuilder.transform(pt.getY(), scale, baseY);
            pts[i] = new Coordinate(x, y);
            ++i;
        }
        return this.geomFactory.createLineString(pts);
    }

    private static double transform(double val, double scale, double offset) {
        return val * scale + offset;
    }
}

