/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.simplify;

import java.util.ArrayList;
import java.util.List;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.LineSegment;
import org.locationtech.jts.index.quadtree.Quadtree;
import org.locationtech.jts.simplify.LineSegmentVisitor;
import org.locationtech.jts.simplify.TaggedLineSegment;
import org.locationtech.jts.simplify.TaggedLineString;

class LineSegmentIndex {
    private Quadtree index = new Quadtree();

    public void add(TaggedLineString line) {
        TaggedLineSegment[] segs = line.getSegments();
        int i = 0;
        while (i < segs.length) {
            TaggedLineSegment seg = segs[i];
            this.add(seg);
            ++i;
        }
    }

    public void add(LineSegment seg) {
        this.index.insert(new Envelope(seg.p0, seg.p1), seg);
    }

    public void remove(LineSegment seg) {
        this.index.remove(new Envelope(seg.p0, seg.p1), seg);
    }

    public List query(LineSegment querySeg) {
        Envelope env = new Envelope(querySeg.p0, querySeg.p1);
        LineSegmentVisitor visitor = new LineSegmentVisitor(querySeg);
        this.index.query(env, visitor);
        ArrayList itemsFound = visitor.getItems();
        return itemsFound;
    }
}

