/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.simplify;

import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateList;
import org.locationtech.jts.geom.Triangle;

class VWLineSimplifier {
    private Coordinate[] pts;
    private double tolerance;

    public static Coordinate[] simplify(Coordinate[] pts, double distanceTolerance) {
        VWLineSimplifier simp = new VWLineSimplifier(pts, distanceTolerance);
        return simp.simplify();
    }

    public VWLineSimplifier(Coordinate[] pts, double distanceTolerance) {
        this.pts = pts;
        this.tolerance = distanceTolerance * distanceTolerance;
    }

    public Coordinate[] simplify() {
        VWVertex vwLine = VWVertex.buildLine(this.pts);
        double minArea = this.tolerance;
        while ((minArea = this.simplifyVertex(vwLine)) < this.tolerance) {
        }
        Coordinate[] simp = vwLine.getCoordinates();
        if (simp.length < 2) {
            return new Coordinate[]{simp[0], new Coordinate(simp[0])};
        }
        return simp;
    }

    private double simplifyVertex(VWVertex vwLine) {
        VWVertex curr = vwLine;
        double minArea = curr.getArea();
        VWVertex minVertex = null;
        while (curr != null) {
            double area = curr.getArea();
            if (area < minArea) {
                minArea = area;
                minVertex = curr;
            }
            curr = curr.next;
        }
        if (minVertex != null && minArea < this.tolerance) {
            minVertex.remove();
        }
        if (!vwLine.isLive()) {
            return -1.0;
        }
        return minArea;
    }

    static class VWVertex {
        public static double MAX_AREA = Double.MAX_VALUE;
        private Coordinate pt;
        private VWVertex prev;
        private VWVertex next;
        private double area = MAX_AREA;
        private boolean isLive = true;

        public static VWVertex buildLine(Coordinate[] pts) {
            VWVertex first = null;
            VWVertex prev = null;
            int i = 0;
            while (i < pts.length) {
                VWVertex v = new VWVertex(pts[i]);
                if (first == null) {
                    first = v;
                }
                v.setPrev(prev);
                if (prev != null) {
                    prev.setNext(v);
                    prev.updateArea();
                }
                prev = v;
                ++i;
            }
            return first;
        }

        public VWVertex(Coordinate pt) {
            this.pt = pt;
        }

        public void setPrev(VWVertex prev) {
            this.prev = prev;
        }

        public void setNext(VWVertex next) {
            this.next = next;
        }

        public void updateArea() {
            if (this.prev == null || this.next == null) {
                this.area = MAX_AREA;
                return;
            }
            this.area = Math.abs(Triangle.area(this.prev.pt, this.pt, this.next.pt));
        }

        public double getArea() {
            return this.area;
        }

        public boolean isLive() {
            return this.isLive;
        }

        public VWVertex remove() {
            VWVertex tmpPrev = this.prev;
            VWVertex tmpNext = this.next;
            VWVertex result = null;
            if (this.prev != null) {
                this.prev.setNext(tmpNext);
                this.prev.updateArea();
                result = this.prev;
            }
            if (this.next != null) {
                this.next.setPrev(tmpPrev);
                this.next.updateArea();
                if (result == null) {
                    result = this.next;
                }
            }
            this.isLive = false;
            return result;
        }

        public Coordinate[] getCoordinates() {
            CoordinateList coords = new CoordinateList();
            VWVertex curr = this;
            do {
                coords.add(curr.pt, false);
            } while ((curr = curr.next) != null);
            return coords.toCoordinateArray();
        }
    }
}

