/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.triangulate;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;

public class VertexTaggedGeometryDataMapper {
    private Map coordDataMap = new TreeMap();

    public void loadSourceGeometries(Collection geoms) {
        for (Geometry geom : geoms) {
            this.loadVertices(geom.getCoordinates(), geom.getUserData());
        }
    }

    public void loadSourceGeometries(Geometry geomColl) {
        int i = 0;
        while (i < geomColl.getNumGeometries()) {
            Geometry geom = geomColl.getGeometryN(i);
            this.loadVertices(geom.getCoordinates(), geom.getUserData());
            ++i;
        }
    }

    private void loadVertices(Coordinate[] pts, Object data) {
        int i = 0;
        while (i < pts.length) {
            this.coordDataMap.put(pts[i], data);
            ++i;
        }
    }

    public List getCoordinates() {
        return new ArrayList(this.coordDataMap.keySet());
    }

    public void transferData(Geometry targetGeom) {
        int i = 0;
        while (i < targetGeom.getNumGeometries()) {
            Geometry geom = targetGeom.getGeometryN(i);
            Coordinate vertexKey = (Coordinate)geom.getUserData();
            if (vertexKey != null) {
                geom.setUserData(this.coordDataMap.get(vertexKey));
            }
            ++i;
        }
    }
}

